/********************************************************************************************************
*
* svc.c
* Author         : A0406448
* Date           : 14/11/2014
*/
/* Copyright (C) 2013-2019 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*---------------------------------------------------------------------------------------------------------------------
* Revision History
*---------------------------------------------------------------------------------------------------------------------
* Version          Date        Author         Description
*---------------------------------------------------------------------------------------------------------------------
* 00.00.00       14/11/2014    A0406448        1. Initial Version
* 00.00.01       24/09/2024    Jagadish G      1. Added license information
***********************************************************************************************************/

#include "sys_common.h"
#include "svc.h"

#ifdef DEBUG
#include <stdio.h>
#endif

extern uint32_t c_svc(uint32_t u32Param1, uint32_t u32Param2, uint32_t u32Handler);

static void testReentrantSvcInThumb(uint32_t * pu32Param1, uint32_t u32Param2)
{
	if (0ul != u32Param2)
	{
		testReentrantSVC(pu32Param1 + 1, u32Param2 - 1ul); /* Call function recursively */

		writePrivRegister32(pu32Param1, (uint32_t)pu32Param1);
	}

	return;
}

uint32_t c_svc(uint32_t u32Param1, uint32_t u32Param2, uint32_t u32Handler)
{
	uint32_t u32ReturnVal = 0ul;

#ifdef DEBUG
	printf("Called C Level SVC Handler #%u\n", u32Handler);
#endif

	switch(u32Handler)
	{
	case 33: /* writePrivRegister32() */
		u32ReturnVal           = *(uint32_t *)u32Param1;
		*(uint32_t *)u32Param1 = u32Param2;
		break;

	case 34: /* writePrivRegister8() */
		u32ReturnVal          = (uint32_t)(*(uint8_t *)u32Param1);
		*(uint8_t *)u32Param1 = (uint8_t)u32Param2;
		break;

	case 35: /* testReentrantSVC */
		testReentrantSvcInThumb((uint32_t *)u32Param1, u32Param2);
		break;

	default:
		ASSERT(0);
		break;
	}

	return u32ReturnVal;
}
